jQuery(function($){
	
	$("#divChecks").hide();
	
	$("#divResultado").hide();
	
	$("#aCerrarAvisoEstacion").click(function(){
		$("#divAvisosEstacion").hide("fade");
	});
	
	$("#divCriteriosBusqueda").rup_accordion({
		collapsible: true
	});
	
	$("#btnBuscar").button({
		icons:{primary: "ui-icon-search"}
	}).click(function(){		
		if (fncValidarBusqueda()){
			
			blockUI_Cargando();
			
			fncCargarAvisosEstacion();
			
		}
		
	});
	
	$("#btnLimpiar").button({
		icons:{
			primary: "ui-icon-trash"
		}
	}).click(function(){
		$("#FORMULARIO_BUSQUEDA").rup_form("clearForm");
		$("#txtFecha").val(fechaActual);
		$("#divChecks").hide();
		$("#divContaminantes").html("");
		//ajusto el height del acordeon
		$("#divCriteriosBusqueda").rup_accordion("resize");
	});
	
	//boton que muestra el popup de exportar
	$("#btnMostrarExportar").button({
		icons:{
			primary: "ui-icon-arrowstop-1-s"
		}
	}).click(function(){
		//antes de mostrar el popup de exportar, valido los datos del formulario
		if (fncValidarBusqueda()){
			//abro el popup de exportar
			$( "#detalleExportar" ).rup_dialog( "open" );
		}
				
	});
	
	//popup de edición 
	$("#detalleExportar").rup_dialog({
		autoOpen: false,
		width: 300,
		modal: true,
		resizable: false,
		position: "center",
		type: $.rup.dialog.DIV
	});
	
	//configuro el formulario de exportar
	$("#FORMULARIO_EXPORTAR").attr('action', $.rup.CTX_PATH + 'informe/datosHorarios?R01HNoPortal=true');
	$("#FORMULARIO_EXPORTAR").attr('method', 'POST');
	$("#FORMULARIO_EXPORTAR").attr("target","_blank");
	
	//boton Exportar
	$("#btnExportar").button({
		icons:{
			primary: "ui-icon-arrowstop-1-s"
		}
	}).click(function(){
		
		//vuelco los datos del filtro al formulario de exportar
		
		$("#idEstacion").val($("#cmbEstacion").rup_combo("getRupValue"));
		$("#nombreEstacion").val($("#cmbEstacion").rup_combo("label")); //vuelco tambien el nombre de la estacion para mostrarlo en el informe
		$("#fechaExportar").val($("#txtFecha").val());
		
		//vuelco tambien los checks de contaminantes que están seleccionados
		$("#divChecksExportar").html(""); //vacio la capa que contendrá los checks
		$("#divChecksExportar").append($("#divContaminantes").find(":checked").clone()); //clono los checks seleccionados al formulario de exportar		
		//me recorro los checks que he clonado para recalcular el indice asignado en el name, ya que sino da problemas al volcarlo al bean
		$("#divChecksExportar").find("input").each(function(i){
			$(this).attr("name","listaContaminantes[" + i + "]");
			
			//genero un hidden por cada contaminante checkeado para guardar su descripcion y mostrarla en el informe
			var objHidden =  $(document.createElement("input"));
			objHidden.attr("type","hidden");
			objHidden.attr("name","listaNombresContaminantes[" + i + "]");
			//obtengo el nombre del contaminante de label asociado al check en el formulario del filtro
			objHidden.attr("value",$("#divContaminantes").find("label[for=" + $(this).attr("id") + "]").text());
			$("#divChecksExportar").append(objHidden);
		});		
		$("#divChecksExportar").find("input").removeAttr("id"); //elimino los ids de los checks para que no se repitan
		
		$("#FORMULARIO_EXPORTAR").submit();
		//window.open($.rup.CTX_PATH+"informe/datosHorarios?R01HNoPortal=true", "Notición", "height=200,width=600,status=yes,toolbar=no,menubar=no,location=no, scrollbars=yes, top=300, left=200, resizable=yes");
		
		$( "#detalleExportar" ).rup_dialog( "close" );
	});
	
	//cargo los avisos generales con el metodo definido en el _layout.js
	cargarAvisosGenerales();
	
	function fncCargarAvisosEstacion(){
		
		$("#lblNomEstacion").text($("#cmbEstacion").rup_combo("label"));		
		
		$("#pAvisosEstacion").html("");
		
		//obtengo la lista de avisos generales
		$.rup_ajax({
			url: $.rup.CTX_PATH+"avisos/estacion/" + $("#cmbEstacion").rup_combo("getRupValue"),
			dataType: 'json',
			type: "GET",
			async: false,
			contentType: 'application/json',		    
			success: function (resultado, ajaxOptions) {
				//si existen avisos para la estación
				if (resultado.length > 0){
					//cargo la lista de avisos generales
					for (var i=0; i<resultado.length; i++){
						
						var div = $(document.createElement("div"));
						$(div).text("- " + resultado[i].textoAviso);
						
						$("#pAvisosEstacion").append($(div));
					}
					
					$("#divAvisosEstacion").show();
				}else{
					//si no hay avisos para la estación, oculto ese bloque
					$("#divAvisosEstacion").hide();
				}
				
				$("#FORMULARIO_BUSQUEDA").submit();
				
			},
			error: function (xhr, ajaxOptions, thrownError) {
				$("#feedbackMensajes").rup_feedback("set", $.rup.i18n.app.mensajes.error.datos_cargar_error, "error");
			}
		});
	}
	
	var anchoComboEstacion=$('#divCriteriosBusqueda').width()*0.25;
	
	$("#cmbEstacion").rup_combo({
		source : $.rup.CTX_PATH+"combo/estaciones",
		sourceParam : {
			label:"descripcion", 
			value:"valor"
		},
		width: anchoComboEstacion,
		blank : "",
		select: function(){
			var valor = $(this).rup_combo("getRupValue");
			if (valor != null && valor != ""){
				cargarContaminantesEstacion($(this).rup_combo("getRupValue"));
			}else{
				$("#divChecks").hide();				
			}
		}
	});
	
	function cargarContaminantesEstacion(idEstacion){
	
		$("#divChecks").hide();
		$("#divContaminantes").html("");
		
		//obtengo la lista de contaminantes para dibujar los checks
		$.rup_ajax({
			url: $.rup.CTX_PATH+"contaminantesestacion/" + idEstacion ,
			dataType: 'json',
			type: "GET",
			async: false,
			contentType: 'application/json',		    
			success: function (resultado, ajaxOptions) {
				
				for (var i=0; i<resultado.length; i++){
					
					//genero el checkbox
					var chkCheck = $(document.createElement("input"));
					$(chkCheck).attr("type","checkbox");
					$(chkCheck).attr("class","checkContaminante");
					$(chkCheck).attr("value",resultado[i].idContaminante);
					$(chkCheck).attr("id","chkContaminante" + resultado[i].idContaminante);
					$(chkCheck).attr("name","listaContaminantes[" + i + "]");
					
					//genero su label
					var lblLabel = $(document.createElement("label"));
					$(lblLabel).text(resultado[i].contaminante.nombreContaminante);
					$(lblLabel).attr("for","chkContaminante" + resultado[i].idContaminante);
					
					//genero la capa que contendra el checkbox y el label
					var divCheck = $(document.createElement("div"));
					$(divCheck).addClass("float-left ancho_15");
					
					$(divCheck).append($(chkCheck)); //añado el checkbox
					$(divCheck).append($(lblLabel)); //añado el label
					
					
					$("#divContaminantes").append($(divCheck)); //añado la capa al div que contiene todos los checkbox
					
				}
				
				
				
			},
			error: function (xhr, ajaxOptions, thrownError) {
				$("#feedbackMensajes").rup_feedback("set", $.rup.i18n.app.mensajes.error.datos_cargar_error, "error");
			}
		});
		
		//muestro la capa de los checks que acabo de rellenar
		$("#divChecks").show("fade");
		
		//ajusto el height del acordeon
		$("#divCriteriosBusqueda").rup_accordion("resize");		
		
	}
	
	function fncValidarBusqueda(){
		
		var strMensaje = "";
		var strSeparador = "";
		
		if ($("#cmbEstacion").rup_combo("getRupValue") == ""){			
			strMensaje = " - " + $.rup.i18n.app.mensajes.alert.debe_seleccionar_estacion;
			strSeparador = "<br /><br />";			
		}
		
		//si no hay ningún check de contaminante seleccionado
		if ($(".checkContaminante:checked").length == 0){
			strMensaje += strSeparador + " - " + $.rup.i18n.app.mensajes.alert.debe_seleccionar_contaminante;
			strSeparador = "<br /><br />";
		}
		
		if ($("#txtFecha").rup_date("getDate") == ""){
			strMensaje += strSeparador + " - " + $.rup.i18n.app.mensajes.alert.debe_seleccionar_fecha;
		}else{
			//valido si es una fecha correcta
			var valida = $.rup_validate.checkDate($.rup.i18n.base.rup_validate.format.date,$("#txtFecha").rup_date("getDate"));
			if (!valida){
				//si no es correcta, muestro mensaje de error
				strMensaje += strSeparador + " - " + $.rup.i18n.base.rup_validate.messages.date;
			}
			
		}
		
		if (strMensaje != ""){
			$("#feedbackMensajes").rup_feedback("set", strMensaje, "alert");
			return false;
		}else{
			return true;
		}
		
	}
	
	$("#FORMULARIO_BUSQUEDA").rup_form({
		url:$.rup.CTX_PATH+"datohorario",
		feedback:$("#feedbackMensajes"),
		type: "POST",
		dataType: "json",
		success:function(xhr){
			
			$("#feedbackMensajes").rup_feedback("hide"); //oculto las validaciones.
			
			//limpio la capa que contiene todos los gráficos
			$("#divContenedorGraficos").html("");
			//$("#divContenedorGraficos").find("div").remove();
			$("#divResultado").show();
			
			if (xhr != null && xhr.length >0){
				
				//oculto los criterios de busqueda
				$("#divCriteriosBusqueda").accordion({
					  active: false
				});
				
				$("#divMensajeNoHayDatos").hide();
				$("#divContenedorGraficos").show();
			
				for (var i=0; i<xhr.length;i++){
					//dibujo un grafico y una tabla por cada contaminante
					fncCargarGrafico(xhr[i]);
				}
				
				//defino todos los acordeones que acabo de generar
				$(".acordeonResultado").rup_accordion({
					collapsible: true
				});
				
				
			}else{
				$("#divMensajeNoHayDatos").show();
				$("#divContenedorGraficos").hide();
			}
			
			$.unblockUI();
		},
		error: function (xhr, ajaxOptions, thrownError) {
			$("#feedbackMensajes").rup_feedback("set", $.rup.i18n.app.mensajes.error.datos_cargar_error, "error");
			$.unblockUI();
			
		},
		validate:{
			rules:{
				//"idEstacion":{required:true},
				"fechaDato":{date:true}
			},
			invalidHandler: function () {
				$.unblockUI();
			}
		}
	});	
	
	function fncCargarGrafico(datos){
		
		var datosGrafico = 
		[{
			name: datos.contaminante.nombreContaminante,
			data: datos.listaValores						
		}];
		
		var idGrafico = "grafico" + datos.contaminante.idContaminante;
		var tituloGrafico = datos.contaminante.nombreContaminante + " - " + datos.nombreEstacion;
		var subtituloGrafico = datos.fechaDato + " - " +  $.rup.i18n.app.graficos.horasGMT;
		
		var tipoGrafico = {
			type: 'areaspline',
			zoomType: 'x'
		};
		
		var plantilla = $("#divPlantilla").clone();
		$(plantilla).removeAttr("id");
		$(plantilla).find(".tituloAcordeon").text(datos.contaminante.nombreContaminante + " - " + datos.nombreEstacion);
		
		//tabla
		var idTabla = "tabla" + datos.contaminante.idContaminante;
		$(plantilla).find(".tblDatos").attr("id",idTabla);
		
		//grafico
		$(plantilla).find(".divGrafico").attr("id",idGrafico);
		$(plantilla).find(".divGrafico").css("width",$('#divCriteriosBusqueda').width()*0.94);
		
		//limites
		var arrLimites = fncObtenerLimitesContaminante(datos.contaminante.idContaminante);
		
		$(plantilla).find(".cambiarGrafico").data("grafico",idGrafico);
		$(plantilla).find(".cambiarGrafico").data("titulo",tituloGrafico);
		$(plantilla).find(".cambiarGrafico").data("subtitulo",subtituloGrafico);
		$(plantilla).find(".cambiarGrafico").data("datos",datosGrafico);
		$(plantilla).find(".cambiarGrafico").data("medida",datos.contaminante.unidadMedida);
		$(plantilla).find(".cambiarGrafico").data("limites",arrLimites);
		$(plantilla).find(".cambiarGrafico").change(function(){
			
			var idGrafico = $(this).data("grafico");
			var titulo = $(this).data("titulo");
			var subtitulo = $(this).data("subtitulo");
			var datos = $(this).data("datos");
			var medida = $(this).data("medida");
			var limites = $(this).data("limites");
			
			var tipo = {
				type: $(this).val(),
				zoomType: 'x'
			};
			
			cargarGraficoHoras(idGrafico, titulo, subtitulo, datos, medida, tipo, limites);
		});
		
		$("#divContenedorGraficos").append($(plantilla));
		
		//cargo el gráfico
		cargarGraficoHoras(idGrafico, tituloGrafico, subtituloGrafico, datosGrafico, datos.contaminante.unidadMedida, tipoGrafico, arrLimites);
		
		//cargo la tabla del contaminante
		fncCargarTablaContaminante(idTabla, datos);
		
	}
	
	function cargarGraficoHoras(idCapa, titulo, subtituloGrafico, datosSeries, unidadMedida, tipoGrafico, limites){
		$("#"+idCapa).highcharts({
			chart: tipoGrafico,
			title: {
				text: titulo
			},
			subtitle: {
				text: subtituloGrafico
			},
			xAxis: {
				categories: ['1', '2', '3', '4', '5', '6', '7','8','9','10','11','12','13','14','15','16','17','18','19','20','21','22','23','24']
			},
			yAxis: {
				title: {
					text: unidadMedida
				},
				plotLines: limites
			},
			tooltip: {
				valueSuffix: ' ' + unidadMedida
			},
			legend: {
				layout: 'vertical',
				align: 'right',
				verticalAlign: 'middle',
				borderWidth: 0
			},
			series: datosSeries,
			plotOptions: {
				line: {
					dataLabels: {
						enabled: true
					},
					enableMouseTracking: false
				}
			}
		});
	}
	
	function fncCargarTablaContaminante(idTabla, datos){
		var objTR = $(document.createElement("tr"));
		
		$(objTR).append(fncGenerarTD(datos.contaminante.nombreContaminante, "left"));
		$(objTR).append(fncGenerarTD(datos.valorHora01));
		$(objTR).append(fncGenerarTD(datos.valorHora02));
		$(objTR).append(fncGenerarTD(datos.valorHora03));
		$(objTR).append(fncGenerarTD(datos.valorHora04));
		$(objTR).append(fncGenerarTD(datos.valorHora05));
		$(objTR).append(fncGenerarTD(datos.valorHora06));
		$(objTR).append(fncGenerarTD(datos.valorHora07));
		$(objTR).append(fncGenerarTD(datos.valorHora08));
		$(objTR).append(fncGenerarTD(datos.valorHora09));
		$(objTR).append(fncGenerarTD(datos.valorHora10));
		$(objTR).append(fncGenerarTD(datos.valorHora11));
		$(objTR).append(fncGenerarTD(datos.valorHora12));
		$(objTR).append(fncGenerarTD(datos.valorHora13));
		$(objTR).append(fncGenerarTD(datos.valorHora14));
		$(objTR).append(fncGenerarTD(datos.valorHora15));
		$(objTR).append(fncGenerarTD(datos.valorHora16));
		$(objTR).append(fncGenerarTD(datos.valorHora17));
		$(objTR).append(fncGenerarTD(datos.valorHora18));
		$(objTR).append(fncGenerarTD(datos.valorHora19));
		$(objTR).append(fncGenerarTD(datos.valorHora20));
		$(objTR).append(fncGenerarTD(datos.valorHora21));
		$(objTR).append(fncGenerarTD(datos.valorHora22));
		$(objTR).append(fncGenerarTD(datos.valorHora23));		
		$(objTR).append(fncGenerarTD(datos.valorHora24));
		
		$("#" + idTabla).find("tbody").append(objTR);
	}
	
	function fncGenerarTD(pValor, pAlign){
		var objTD = $(document.createElement("td"));
		$(objTD).text((pValor == null ? "" : pValor));
		if (pAlign){
			$(objTD).attr("align", pAlign);
		}else{
			$(objTD).attr("align", "right");
		}
		
		return $(objTD);
	}
	
function fncObtenerLimitesContaminante(pIdContaminante){
		
		var arrLimites = new Array();
		$.rup_ajax({
			//url: $.rup.CTX_PATH+"limitesContaminante/" + $("#cmbContaminante").rup_combo("getRupValue"),
			url: $.rup.CTX_PATH+"limitesContaminante",
			data:{
				idContaminante: pIdContaminante,
				tipoLimite: TIPO_LIMITE_HORARIO
			},
			dataType: 'json',
			type: "GET",
			async: false,
			contentType: 'application/json',		    
			success: function (resultado, ajaxOptions) {
				
				
				if (resultado != null && resultado.length > 0){
					arrLimites.length = resultado.length - 1;
					
					for (var i=0; i<resultado.length; i++){
						
						arrLimites[i]=
						{
							value : resultado[i].valorLimite,
							color :  resultado[i].colorLimite,
							dashStyle : 'shortDashDot',
							width : 2,
							label : {
								text : resultado[i].descripcion + ": " + resultado[i].valorLimite,
								align: 'center'
							},
							zIndex: 1000
						};
						
					}
				}
				
			},
			error: function (xhr, ajaxOptions, thrownError) {
				$("#feedbackMensajes").rup_feedback("set", $.rup.i18n.app.mensajes.error.datos_cargar_error, "error");
				$.unblockUI();
			}
		});
		
		return arrLimites;
		
	}
	
});